import { StyleSheet } from "react-native";
import dpr from "../../screens/Utilities/CustomStyleAttribute/dpr";

export const styles = StyleSheet.create({
    tabBarStyle: {
        shadowColor: "#000000",
        shadowOffset: {
            width: dpr(5),
            height: dpr(12),
        },
        shadowOpacity: 0.06,
        elevation: 24,

        position: "absolute",
        left: 0,
        bottom: 0,
        backgroundColor: "#FFFFFF",
        height: dpr(65),
    },
    singleTabContainer: {
        flexDirection: 'column',
        alignItems: "center",
        justifyContent: "center",
        flexShrink: 1,
        width: dpr(60),
    },
    tabBarLabel:(focused) => ({
        fontSize: dpr(11),
        textAlign: "center",
        marginTop: dpr(7),
        color: focused ? "#2C2C2C" : "#898989",
        fontFamily: focused? "DMSans_700Bold": "DMSans_500Medium",
    }),
    labelArea: {
        position: "relative",
    },
    label: {
        position: "absolute",
        height: dpr(17),
        width: dpr(17),
        backgroundColor: "#C8191C",
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 30,
        right: -5,
        top: -2,
    },
    labelText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(9),
        color: "#fff",
    },
});